#!/bin/bash

clean=$1
TOMCAT_TEMP_CLEAN=$LIFERAY_TOMCAT_HOME/temp/*${clean}
TOMCAT_WEBAPPS_CLEAN=$LIFERAY_TOMCAT_HOME/webapps/${clean}
TOMCAT_WORK_CLEAN=$LIFERAY_TOMCAT_HOME/work/Catalina/localhost/${clean}
LIFERAY_OSGI_CLEAN=$LIFERAY_HOME/data/osgi


if [ ! -z $clean ]; then # ensure that 'clean' is not empty. An empty string will remove everything.

	echo "Cleaning Tomcat Temp: ${TOMCAT_TEMP_CLEAN} ..."
	rm -rf ${TOMCAT_TEMP_CLEAN} 
	clean_1=$?
	
	echo "Cleaning Tomcat Webapps: ${TOMCAT_WEBAPPS_CLEAN} ..."
    rm -rf ${TOMCAT_WEBAPPS_CLEAN}
    clean_2=$?
	
	echo "Cleaning Tomcat Work: ${TOMCAT_WORK_CLEAN} ..."
	rm -rf ${TOMCAT_WORK_CLEAN}
	clean_3=$?
	
	echo "Cleaning Liferay OSGI data: ${LIFERAY_OSGI_CLEAN} ..."
	rm -rf ${LIFERAY_OSGI_CLEAN}
	clean_4=$?

	clean_total=$((clean_1+clean_2+clean_3+clean_4));
	
	if [ $clean_total != 0 ]; then
		echo "Cleanup Failed!!!"
		echo "Tomcat Temp: ${clean_1}."
		echo "Tomcat Webapps: ${clean_2}."
		echo "Tomcat Work: ${clean_3}."
		echo "Liferay OSGI: ${clean_4}."
	fi

fi

